*! version 0.8.0
program define GMSS_estat, rclass
	version 19.0

	syntax anything [, GMSS(string) EQnum(numlist)]
	
	local cmd `anything'
	if "`gmss'" == "" {
		local gmss "`e(moptname)'"
	}
	
	if "`eqnum'" == "" {
		local eqnum "1"
	}
	
	tempname value
	
	if "`cmd'" == "value" {
		mata: GetValue("`gmss'", "`value'")
		noi di 
		noi di as txt "Optimization function final value = " as res %9.0g `value'
		ret scalar value = `value'
		exit
	}
	
	if "`cmd'" == "value0" {
		mata: GetValue0("`gmss'", "`value'")
		noi di 
		noi di as txt "Optimization null function final value = " as res %9.0g `value'
		ret scalar value0 = `value'
		exit
	}
	
	if "`cmd'" == "scores" {
		mata: GetScores("`gmss'", "`value'")
		noi di 
		noi di as txt "Optimization scores" 

		noi mat list `value', noheader
		ret matrix scores = `value'
		exit
	}
	
	if "`cmd'" == "gradient" {
		mata: GetGradient("`gmss'", "`value'")
		noi di 
		noi di as txt "Optimization gradient" 

		noi mat list `value', noheader
		ret matrix gradient = `value'
		exit
	}
	
	if "`cmd'" == "Hessian" {
		mata: GetHessian("`gmss'", "`value'")
		noi di 
		noi di as txt "Optimization Hessian" 

		noi mat list `value', noheader
		ret matrix Hessian = `value'
		exit
	}
	
	if "`cmd'" == "V" {
		mata: GetV("`gmss'", "`value'")
		noi di 
		noi di as txt "Optimization V" 

		noi mat list `value', noheader
		ret matrix V = `value'
		exit
	}
	
	if "`cmd'" == "V_oim" {
		mata: GetVoim("`gmss'", "`value'")
		noi di 
		noi di as txt "Optimization V_oim" 

		noi mat list `value', noheader
		ret matrix V_oim = `value'
		exit
	}
	
	if "`cmd'" == "V_opg" {
		mata: GetVopg("`gmss'", "`value'")
		noi di 
		noi di as txt "Optimization V_opg" 

		noi mat list `value', noheader
		ret matrix V_opg = `value'
		exit
	}
	
	if "`cmd'" == "V_robust" {
		mata: GetVrobust("`gmss'", "`value'")
		noi di 
		noi di as txt "Optimization V_robust" 

		noi mat list `value', noheader
		ret matrix V_robust = `value'
		exit
	}
	
	if "`cmd'" == "ll" {
		mata: GetLL("`gmss'", "`value'")
		tempname gg
		mat `gg' = J(1, rowsof(`value'), 1) * `value'
		noi di 
		noi di as txt "Optimization loglikelihood = " as res %8.0g `gg'[1,1] 

		noi mat list `value', noheader
		ret matrix ll_vec = `value'
		ret scalar ll = `gg'[1,1]
		exit
	}
	
	if "`cmd'" == "gdev" {
		mata: GetLL("`gmss'", "`value'")
		mat `value' = -2 * `value'
		tempname gg
		mat `gg' = J(1, rowsof(`value'), 1) * `value'
		noi di 
		noi di as txt "Optimization global deviance = " as res %8.0g `gg'[1,1] 
		
		
		noi mat list `value', noheader
		ret matrix gdev_vec = `value'
		ret scalar gdev = `gg'[1,1]
		exit
	}
	
	if "`cmd'" == "dldtheta" {
		numlist "`eqnum'", min(1) max(1)
		local u : word 1 of `r(numlist)'
		mata: Getdldtheta("`gmss'", "`value'", `u')
		noi di 
		noi di as txt "Optimization (d loglikelihood)/(d theta_`u')" 

		noi mat list `value', noheader
		ret matrix dldtheta_`u' = `value'
		exit
	}
	
	if "`cmd'" == "theta" {
		numlist "`eqnum'", min(1) max(1)
		local u : word 1 of `r(numlist)'
		mata: Gettheta("`gmss'", "`value'", `u')
		noi di 
		noi di as txt "theta_`u' = g^-1(p_`u')" 

		noi mat list `value', noheader
		ret matrix theta_`u' = `value'
		exit
	}
	
	if "`cmd'" == "p" {
		numlist "`eqnum'", min(1) max(1)
		local u : word 1 of `r(numlist)'
		mata: Getp("`gmss'", "`value'", `u')
		noi di 
		noi di as txt "Linear predictor : p_`u'" 

		noi mat list `value', noheader
		ret matrix p_`u' = `value'
		exit
	}
	
	if "`cmd'" == "dthetadp" {
		numlist "`eqnum'", min(1) max(1)
		local u : word 1 of `r(numlist)'
		mata: Getdthetadp("`gmss'", "`value'", `u')
		noi di 
		noi di as txt "dtheta_`u'/dp_`u'" 

		noi mat list `value', noheader
		ret matrix theta_`u' = `value'
		exit
	}
	
	if "`cmd'" == "d2thetadp2" {
		numlist "`eqnum'", min(1) max(1)
		local u : word 1 of `r(numlist)'
		mata: Getd2thetadp2("`gmss'", "`value'", `u')
		noi di 
		noi di as txt "d^2 theta_`u' / dp_`u'^2" 

		noi mat list `value', noheader
		ret matrix theta_`u' = `value'
		exit
	}
	
	if "`cmd'" == "d2ldtheta2" {
		numlist "`eqnum'", min(1) max(2)
		local u : word 1 of `r(numlist)'
		local v : word 2 of `r(numlist)'
		if "`v'"=="" {
			local v = `u'
		}
		mata: Getd2ldtheta2("`gmss'", "`value'", `u', `v')
		noi di 
		noi di as txt "Optimization (d^2 loglikelihood)/(d theta_`u' d theta_`v')" 

		noi mat list `value', noheader
		ret matrix d2ldtheta2_`u'_`v' = `value'
		exit
	}
	
	if "`cmd'" == "ed2ldtheta2" {
		numlist "`eqnum'", min(1) max(2)
		local u : word 1 of `r(numlist)'
		local v : word 2 of `r(numlist)'
		if "`v'"=="" {
			local v = `u'
		}
		mata: Geted2ldtheta2("`gmss'", "`value'", `u', `v')
		noi di 
		noi di as txt "Optimization E[(d^2 loglikelihood)/(d theta_`u' d theta_`v')]" 

		noi mat list `value', noheader
		ret matrix ed2ldtheta2_`u'_`v' = `value'
		exit
	}

    if "`cmd'" == "rsquared" {
    }
	
	noi di as err "No such calculation (`cmd')"
	
end

mata
void function GetValue(string scalar optname, valname) 
{
	pointer(struct GMSS scalar) scalar gmssp
	
	gmssp = findexternal(optname)
	val = moptimize_result_value(gmssp->optm)
	st_numscalar(valname, val)
}

void function GetValue0(string scalar optname, valname) 
{
	pointer(struct GMSS scalar) scalar gmssp
	
	gmssp = findexternal(optname)
	val = moptimize_result_value0(gmssp->optm)
	st_numscalar(valname, val)
}

void function GetScores(string scalar optname, valname) 
{
	pointer(struct GMSS scalar) scalar gmssp

	gmssp = findexternal(optname)
	val = moptimize_result_scores(gmssp->optm)
	val
	st_matrix(valname, val)
}

void function GetGradient(string scalar optname, valname) 
{
	pointer(struct GMSS scalar) scalar gmssp

	gmssp = findexternal(optname)
	val = moptimize_result_gradient(gmssp->optm)
	st_matrix(valname, val)
	st_matrixcolstripe(valname, st_matrixcolstripe("e(b)"))
}

void function GetHessian(string scalar optname, valname) 
{
	pointer(struct GMSS scalar) scalar gmssp

	gmssp = findexternal(optname)
	val = moptimize_result_Hessian(gmssp->optm)
	st_matrix(valname, val)
	st_matrixcolstripe(valname, st_matrixcolstripe("e(V)"))
	st_matrixrowstripe(valname, st_matrixrowstripe("e(V)"))
}

void function GetV(string scalar optname, valname) 
{
	pointer(struct GMSS scalar) scalar gmssp

	gmssp = findexternal(optname)
	val = moptimize_result_V(gmssp->optm)
	st_matrix(valname, val)
	st_matrixcolstripe(valname, st_matrixcolstripe("e(V)"))
	st_matrixrowstripe(valname, st_matrixrowstripe("e(V)"))
}

void function GetVoim(string scalar optname, valname) 
{
	pointer(struct GMSS scalar) scalar gmssp

	gmssp = findexternal(optname)
	val = moptimize_result_V_oim(gmssp->optm)
	st_matrix(valname, val)
	st_matrixcolstripe(valname, st_matrixcolstripe("e(V)"))
	st_matrixrowstripe(valname, st_matrixrowstripe("e(V)"))
}

void function GetVopg(string scalar optname, valname) 
{
	pointer(struct GMSS scalar) scalar gmssp

	gmssp = findexternal(optname)
	val = moptimize_result_V_opg(gmssp->optm)
	st_matrix(valname, val)
	st_matrixcolstripe(valname, st_matrixcolstripe("e(V)"))
	st_matrixrowstripe(valname, st_matrixrowstripe("e(V)"))
}

void function GetVrobust(string scalar optname, valname) 
{
	pointer(struct GMSS scalar) scalar gmssp

	gmssp = findexternal(optname)
	val = moptimize_result_V_robust(gmssp->optm)
	st_matrix(valname, val)
	st_matrixcolstripe(valname, st_matrixcolstripe("e(V)"))
	st_matrixrowstripe(valname, st_matrixrowstripe("e(V)"))
}

void function GetLL(string scalar optname, valname) 
{
	pointer(struct GMSS scalar) scalar gmssp

	gmssp = findexternal(optname)
	val = gmssp->dist->loglik() 
	st_matrix(valname, val)
}


void function Gettheta(string scalar optname, valname, real scalar u) 
{
	pointer(struct GMSS scalar) scalar gmssp

	gmssp = findexternal(optname)
	val = gmssp->dist->lnk[u]->theta
	st_matrix(valname, val)
}

void function Getp(string scalar optname, valname, real scalar u) 
{
	pointer(struct GMSS scalar) scalar gmssp

	gmssp = findexternal(optname)
	val = gmssp->dist->lnk[u]->p
	st_matrix(valname, val)
}

void function Getdthetadp(string scalar optname, valname, real scalar u) 
{
	pointer(struct GMSS scalar) scalar gmssp

	gmssp = findexternal(optname)
	val = gmssp->dist->lnk[u]->dtheta
	st_matrix(valname, val)
}

void function Getd2thetadp2(string scalar optname, valname, real scalar u) 
{
	pointer(struct GMSS scalar) scalar gmssp

	gmssp = findexternal(optname)
	val = gmssp->dist->lnk[u]->d2theta
	st_matrix(valname, val)
}

void function Getdldtheta(string scalar optname, valname, real scalar u) 
{
	pointer(struct GMSS scalar) scalar gmssp

	gmssp = findexternal(optname)
	val = gmssp->dist->dldtheta(u) :* gmssp->dist->dpar(u)
	st_matrix(valname, val)
}

void function Getd2ldtheta2(string scalar optname, valname, real scalar u, real scalar v) 
{
	pointer(struct GMSS scalar) scalar gmssp

	gmssp = findexternal(optname)
	val = gmssp->dist->d2ldtheta2(u,v) :* gmssp->dist->dpar(u) :* gmssp->dist->dpar(v) :+ 
				((u==v) ? gmssp->dist->dldpar(u) :* gmssp->dist->d2par(u) : 0)
	st_matrix(valname, val)
}

void function Geted2ldtheta2(string scalar optname, valname, real scalar u, real scalar v) 
{
	pointer(struct GMSS scalar) scalar gmssp

	gmssp = findexternal(optname)
	val = gmssp->dist->ed2ldtheta2(u,v) :* gmssp->dist->dpar(u) :* gmssp->dist->dpar(v) :+ 
				((u==v) ? gmssp->dist->dldpar(u) :* gmssp->dist->d2par(u) : 0)
	st_matrix(valname, val)
}


end
