*! version 0.8.0
program define GMSS_pred
	version 19.0
	syntax newvarname [if] [in] , [xb mu dmu d2mu dldeta dldmu d2ldeta2 d2ldmu2 p0 dp0dtheta dp0dmu d2p0dtheta2 d2p0dmu2 score Residuals EQnum(string) gmss(string)]
	
	quietly {
		if "`gmss'" == "" {
			local gmss "`e(mataname)'"
		}
		
		local option `xb' `mu' `dmu' `d2mu' `dldeta' `dldmu' `d2ldeta2' `d2ldmu2' `p0' `dp0dtheta' `dp0dmu' `d2p0dtheta2' `d2p0dmu2'  `score' `residuals'
		local nopts : word count `option'  
		if `nopts' > 1 {
			display "{err}only one statistic may be specified"
			exit 498
		}
		if `nopts'==0 {
			local option mu
		}
		
		local origopt `option'
		if "`option'" == "residuals" {		// !! expand
			local option "mu"
		}
		
		local num1 : word 1 of `eqnum'
		local num2 : word 2 of `eqnum'
		
		if "`num1'" == "" {
			local num1 "1"
		}
		if "`num2'" == "" {
			local num2 "1"
		}
		confirm integer number `num1'
		confirm integer number `num2'
	
		marksample touse, novarlist
		sort `touse'
		
		// Create id variable and return variable
		tempvar idvar retval
		gen long `idvar'       = _n
		gen `typlist' `retval' = .
		
		summ `idvar' if `touse'
		
		//noi di as err "mata: GMSS_GetPredVal(`gmss', `option', `retval', `r(min)', `r(max)', `num1', `num2')"
		mata: GMSS_GetPredVal("`gmss'", "`option'", "`retval'", `r(min)', `r(max)', `num1', `num2')
		if "`origopt'"=="residuals" {
			replace `retval' = `e(depvar)' - `retval'
		}
		replace `retval' = . if `touse'==0
		rename `retval' `varlist'
		if "`option'" != "d2ldeta2" & "`option'" != "d2ldmu2" {
			local option `option'(`num1') from `gmss'
		}
		else {
			local option `option'(`num1' `num2') from `gmss'
		}
		label var `varlist' "`option'"
	}
end

mata

void function GMSS_GetPredVal(string scalar optname, string scalar opt, string scalar vlist, real scalar obsmin, real scalar obsmax, real scalar u, real scalar v)
{
	real                        colvector origpu, origpv, req
	real                        scalar    oobs
	real                        matrix    V, S
	pointer(struct GMSS scalar) scalar    gmssp
	
	gmssp  = findexternal(optname)
	origpu = gmssp->dist->lnk[u]->p			// save original vector
	origpv = gmssp->dist->lnk[v]->p			// save original vector
	oobs   = gmssp->dist->nobs				// save original number of obs
	
	st_view(V, (obsmin, obsmax), vlist)
	
	gmssp->dist->nobs = obsmax - obsmin + 1																// replace with requested vector size
	gmssp->dist->lnk[u]->p = moptimize_util_xb(gmssp->optm, moptimize_result_eq_coefs(gmssp->optm), u) 	// replace with x*b using current data
	gmssp->dist->lnk[v]->p = moptimize_util_xb(gmssp->optm, moptimize_result_eq_coefs(gmssp->optm), v) 	// replace with x*b using current data
	
	// if (classname(*gmssp->dist) == "GMSS_Dist_Ordered" | classname(*gmssp->dist) == "GMSS_Dist_Ordered2") 

	
	if (opt=="xb") {
		req = gmssp->dist->lnk[u]->p
	}
	
	if (opt=="mu") {
		gmssp->dist->lnk[u]->ginv()			// update theta
		req = gmssp->dist->lnk[u]->theta
	}
	
	if (opt=="score") {
		S = moptimize_result_scores(gmssp->optm)
		req = S[.,u]
	}
	
	if (opt=="dmu") {
		gmssp->dist->lnk[u]->ginv()			// update theta
		gmssp->dist->lnk[u]->update_dpars()
		req = GMSS_Vector(gmssp->dist->dpar(u), gmssp->dist->nobs)
	}
	
	if (opt=="d2mu") {
		gmssp->dist->lnk[u]->ginv()			// update theta
		gmssp->dist->lnk[u]->update_dpars()
		req = GMSS_Vector(gmssp->dist->d2par(u), gmssp->dist->nobs)
	}
	
	if (opt=="dldmu") {
		gmssp->dist->lnk[u]->ginv()			// update theta
		gmssp->dist->lnk[u]->update_dpars()
		req = GMSS_Vector(gmssp->dist->dldpar(u), gmssp->dist->nobs)
	}
	
	if (opt=="dldeta") {					// This is really just the score
		gmssp->dist->lnk[u]->ginv()			// update theta
		gmssp->dist->lnk[u]->update_dpars()
		req = GMSS_Vector(gmssp->dist->dldpar(u):*gmssp->dist->dpar(u), gmssp->dist->nobs)
	}
	
	if (opt=="d2ldmu2") {
		gmssp->dist->lnk[u]->ginv()			// update theta
		gmssp->dist->lnk[u]->update_dpars()
		gmssp->dist->lnk[v]->ginv()			// update theta
		gmssp->dist->lnk[v]->update_dpars()
		req = GMSS_Vector(gmssp->dist->d2ldpar2(u,v), gmssp->dist->nobs)
	}
	
	if (opt=="d2ldeta2") {
		gmssp->dist->lnk[u]->ginv()			// update theta
		gmssp->dist->lnk[u]->update_dpars()
		gmssp->dist->lnk[v]->ginv()			// update theta
		gmssp->dist->lnk[v]->update_dpars()
		req = GMSS_Vector(gmssp->dist->d2ldpar2(u,v):*gmssp->dist->dpar(u):*gmssp->dist->dpar(v) :+ 
					(u==v) :* gmssp->dist->dldpar(u):*gmssp->dist->d2par(u), gmssp->dist->nobs)
	}
	
	if (opt=="ll") {															// !!
		req = gmssp->dist->loglik()
	}
	
	if (opt=="gdev") {															// !!
		req = -2 :* gmssp->dist->loglik() 
	}
	
	V[.,1] = req							// Store request into variable	
	gmssp->dist->lnk[u]->p = origpu			// Put everything back for parameter u (just in case caller had changed data used in estimation)
	gmssp->dist->lnk[u]->ginv()
	gmssp->dist->lnk[u]->update_dpars()
	gmssp->dist->lnk[v]->p = origpv			// Put everything back for parameter v
	gmssp->dist->lnk[v]->ginv()
	gmssp->dist->lnk[v]->update_dpars()
	gmssp->dist->nobs = oobs
}

end

exit


Do not use putmata/getmata from ado-files.  Use st_data() and st_view(); also see st_store()

moptimize_init_eq_coefs(M, i, b0)
moptimize_evaluate(M)
_moptimize_evaluate(M)

st_nobs() returns number of obs
st_nvar() returns number of vars
st_varindex() returns index of variable from name
st_varname() returns variable name from index
st_data()
st_view()
st_subview() 
st_store()


st_view(X, ., "varnames", "touse")








putmata vecname=varname, id(name)     equal values of variable name and matrix name
putmata matname=(varlist), id(varname=vecname)

getmata x1 x2   creates variables x1 and x2 using values from mata vectors x1 and x2  [, replace]
id(name) and id(varname=vecname)  when used with getmata
	* specifies how the rows of the mata vectors match observations in stata data
	* data observation i matches mata row j if variable name[i] = vector name[j]   (1st syntax)
	* data observation i matches mata row j if variable varname[i] = vector vecname[j]  (2nd syntax)
	
	
Stata:
  gen id = _n
  putmata id=id if touse
  
  * now do shit in mata
  
  getmata mu=mu, id(id)
  
st_global("e(predict)", "GMSS_pred")
  
  
