
// Demo for presentation

adopath ++ . 


***********
* Optimization options for regression
use dta/auto, clear
gmss link mean, y(price) x(weight displ) cons(off)	// Link for mean parm
gmss link sdev, cons(on) 					        // Link for std. dev parm
gmss dist gauss, name(normal) link(mean sdev)		// Distribution
gmss opt  d2, evaluator(d2) search(on) random(on)  	// Optimization options
gmss init regmodel, dist(gauss) opt(d2)				// Initialization of model
gmss run regmodel, noheader
exit



***********
gmss opt lf, evaluator(lf) technique(nm)
gmss init regmodel3, dist(gauss) opt(lf)				
mata: delta = J(1,4,1e-5)
mata: moptimize_init_nmsimplexdeltas(regmodel3.optm, delta)
gmss run regmodel3, noheader
exit




***********
* Helper distributions (count)
use dta/rwm1984, clear

gmss clear

gmss opt  d2debug, evaluator(d2debug) maxiter(8) tracelevel(hessian) 
gmss opt  d2,      evaluator(d2) maxiter(20) search(on) 
gmss link count  , y(docvis) x(edlevel age self) 
gmss link sigma  , cons(on) x(age)
gmss link lnkp   , cons(on)
gmss link infl   , cons(on) label(logit_inf_0) name(logit)
gmss dist cntn   , name(nbinomialp)  link(count sigma lnkp)
gmss dist cntp   , name(poisson)  link(count)
gmss dist zinf   , name(zeroinflatedtau) link(infl)

gmss init binom  , dist(zinf cntp) opt(d2)
gmss run binom,   
exit



***********
* Helper distributions (binomial)
use dta/binreg, clear

gmss opt  d2debug, evaluator(d2debug) maxiter(8) tracelevel(hessian) search(on) singular(m-marquardt)
gmss opt  d2,      evaluator(d2) maxiter(20) search(on) random(on) 

gmss link countn , y(y) x(x1 x2) n(n)
gmss link sigma  , cons(on) x(x1)
gmss link inf0   , cons(on) label(tau_0) name(log)
gmss link infn   , cons(on) label(tau_n) name(log)
gmss dist binb   , name(binomial) link(countn) 
gmss dist zinf   , name(zeroninflatedtau) link(inf0 infn)

gmss init binom  , dist(zinf binb) opt(d2)
gmss run binom, noheader



