*! version 0.8.0  13jan2025  // Not intended for users
program define gmssutil, rclass
    version 19.0
    syntax anything [, *]
    quietly {
        gettoken cmd varlist : anything
        GMSS_`cmd' `varlist', `options'
        if "`cmd'" == "getX" {
            matrix cnsv = r(vec)
			matrix cnsm = r(mat)
			ret matrix Cnsm = cnsm
			ret matrix Cnsv = cnsv
            ret scalar p = r(p)
            ret local  varlist `r(varlist)'
			exit
        }
		return clear
    }
end

// Program to expand a covariate list and create the
// associated constraint matrix.  From David Drukker blog.
// Returns:
//      r(varlist) = expanded variable list (WITHOUT the name "_cons")
//      r(cnsv)    = matrix (row vector) of ommitted variables (WITH a column for _cons if applicable)
//      r(cnsm)    = constraint matrix for ommitted variables (WITH a column for _cons if applicable, WITHOUT final column of zeros)
//      r(p)       = number of columns of r(bto)
capture program drop GMSS_getX
program define GMSS_getX, rclass
    syntax [varlist(fv ts default=none)] [, cons(string) ]
    quietly {
		if "`varlist'" != "" {
			_rmcoll `varlist', expand
			local vl `r(varlist)'
		}

        local v `vl'
        if "`cons'" == "on" {
            local v `v' _cons
        }
        local p : word count `v'
		if (`p' == 0) {
			noi di as err "No variables specified and no constant included"
			exit 198
		}
        tempname vv mm vt
        mat `vv' = J(1, `p', 0)
        mat colnames `vv' = `v'
        _ms_omit_info `vv'
        matrix `vv' = r(omit)
        mat colnames `vv' = `v'
		
		local flag 1
		mat `vt' = `vv' * `vv''
		local nc = `vt'[1,1]
		if `nc' {
			forvalues i=1/`p' {
				if `vv'[1,`i'] == 1 {
					mat `vt' = J(1,`p',0)
					mat `vt'[1,`i'] = 1
					if `flag' {
						mat `mm' = `vt'
						local flag = 0
					}
					else {
						mat `mm' = `mm' \ `vt'
					}
					
				}
			}
		}
		else {
			mat `mm' = `vv'
		}
		ret matrix mat = `mm'
        ret matrix vec = `vv'
        ret scalar p = `p'
        ret local  varlist `vl'
    }
end
