{smcl}
{* *! version 0.8.0  07march2025}{...}
{viewerjumpto "Syntax" "gmss##syntax"}{...}
{viewerjumpto "Options" "gmss##options"}{...}
{viewerjumpto "Distribution names" "gmss##distname"}{...}
{viewerjumpto "Distribution Parameters" "gmss_dist##distparm"}{...}
{viewerjumpto "Distribution Variances" "gmss_dist##distvar"}{...}
{viewerjumpto "Link names" "gmss##linkname"}{...}
{viewerjumpto "Description" "gmss##description"}{...}
{viewerjumpto "Remarks" "gmss##remarks"}{...}
{viewerjumpto "Stored Results" "gmss##results"}{...}
{viewerjumpto "Version" "gmss##version"}{...}
{viewerjumpto "Authors" "gmss##authors"}{...}
{viewerjumpto "Online References" "gmss_dist##orefs"}{...}
{viewerjumpto "Programming References" "gmss_dist##prefs"}{...}
{viewerjumpto "References" "gmss_dist##refs"}{...}

{p2colset 1 9 14 2}{...}
{p2col:{bf:gmss} {hline 2}}Generalized Model Specification System(GMSS){p_end}
{p2colreset}{...} 



{marker syntax}{...}
{title:Syntax}

{pstd}
Defining a link

{p 8 15 2}
{cmd:gmss link} 
{it:gmssname}
	 [{cmd:,} {opth name:(gmss##linkname:linkname)} {it:link_options}]

{pstd}
Defining a distribution

{p 8 15 2}
{cmd:gmss} {cmdab:dist:ribution} 
{it:gmssname}
	{cmd:,} {opth name:(gmss##distname:distname)} [{it:distribution_options}]

{pstd}
Defining a set of optimization options

{p 8 15 2}
{cmd:gmss} {cmdab:opt:imization} 
{it:gmssname}
	[{cmd:,} {it:optimization_options}]
	
{pstd}
Initialize a model in terms of distributions, links, and optimization sets

{p 8 15 2}
{cmd:gmss} {cmdab:init:ial} 
{it:gmssname}
	{cmd:,} {cmd:dist(}{it:gmssname}{cmd:}) [{it:init_options}]

{pstd}
Run a specified model in terms of distributions and optimization sets

{p 8 15 2}
{cmd:gmss run} 
{it:gmssname} {ifin}
	[{cmd:,} {it:run_options}]
	
Note: {it:gmssname} is a user-defined name (string) that is 20 characters or less.
	
{marker syntaxother}{...}
{title:Syntax for other utilities}	


{pstd}
Clear defined distributions, links, and optimization sets

{p 8 15 2}
{cmd:gmss clear} 
{it:gmssname}|*
	[{cmd:,} {it:clear_options}]



{marker options}{...}
{title:Options}

{synoptset 29 tabbed}{...}
{synopthdr:options}
{synoptline}
{syntab:Link}
{synopt :{opth name:(gmss##linkname:linkname)}}name of the GMSS link; default links are provided by the GMSS system{p_end}
{synopt :{opt label:(label)}}label to use; the default is to use {it:linkname} and adding an underscore followed by {cmd:mu}, {cmd:sigma}, {cmd:tau}, {cmd:delta}, {cmd:parm5}, {cmd:parm6}, ...{p_end}
{synopt :{opth y:(varname)}}name of the dependent variable (typically only required for the mean parameter){p_end}
{synopt :{opth x:(varlist)}}independent variable list; factor variables are allowed{p_end}
{synopt :{opth n:(varname)}}name of the variable containing the binomial information{p_end}
{synopt :{opt cons:(off|on)}}whether to include a constant (default:{cmd:on}){p_end}
{synopt :{opt offset:(varname)}}name of the variable containing the offset information (default:""){p_end}
{synopt :{opt exposure:(varname)}}name of the variable containing the exposure information (default:""){p_end}
{synopt :{opt init:(matname)}}name of a Stata matrix with starting values (default:""){p_end}
{synopt :{opt aval:(#)}}value on which to model heaping(default:""){p_end}

{syntab:Distribution}
{synopt :{opth name:(gmss##distname:distname)}}name of the GMSS distribution ({it:required}){p_end}
{synopt :{opt link:(gmssnames)}}gmssname(s) of the associated links for the distribution's parameters ({it:required}){p_end}
{* {synopt :{opth touse:(varname)}}name of a variable indicating the sample to be included{p_end}}

{syntab:Optimization}
{synopt :{opt evaluator:(evalname)}}which of {cmd:d0}, {cmd:d1}, {cmd:d2}, {cmd:d1debug}, {cmd:d2debug}, {cmd:lf}, {cmd:lf0}, {cmd:lf1}, {cmd:lf2}, {cmd:lf1debug}, or {cmd:lf2debug} should be used as the evaluator (default:{cmd:d2}){p_end}
{synopt :{opt technique:(techstring)}}which value or string of values of {cmd:nr}, {cmd:dfp}, {cmd:bfgs}, {cmd:bhhh}, {cmd:nm}, or {cmd:gn} should be used (default:{cmd:nr}){p_end}
{synopt :{opt cluster:(varname)}}name of the evaluator to use{p_end}
{synopt :{opt tracelevel:(levelname)}}which of {cmd:none}, {cmd:value}, {cmd:tolerance}, {cmd:step}, {cmd:coefdiffs}, {cmd:paramdiffs}, {cmd:coefs}, {cmd:params}, {cmd:gradient}, {cmd:hessian}, to use (default:{cmd:value}){p_end}
{synopt :{opt tracevalue:(off|on)}}whether to print the log-likelihood(function) value at each iteration (default:{cmd:on}){p_end}
{synopt :{opt maxiter:(#)}}maximum number of iterations (default:{cmd:300}){p_end}
{synopt :{opt svy:(on|off)}}whether to utilize survey information (default:{cmd:off}){p_end}
{synopt :{opt ptol:(#)}}tolerance for relative difference in changes to the parameter vector (default:{cmd:1e-6}){p_end}
{synopt :{opt vtol:(#)}}tolerance for relative difference in changes to the log-likelihood or objective function (default:{cmd:1e-7}){p_end}
{synopt :{opt nrtol:(#)}}tolerance for g*syminv(H)*g' (default:{cmd:1e-5}){p_end}
{synopt :{opt warning:(off|on)}}whether to issue a warning message if convergence is not achieved (default:{cmd:on}){p_end}
{synopt :{opt ignorenrtol:(off|on)}}sets whether to ignore the nrtol as part of declaring convergence (default:{cmd:off}){p_end}
{synopt :{opt search:(off|on)}}sets whether to search for starting values (default:{cmd:on}){p_end}
{synopt :{opt random:(off|on)}}sets whether to search for starting values (default:{cmd:on}){p_end}
{synopt :{opt singular:(m-marquardt|hybrid)}}action to take if Hessian is singular and technique requires full rank (default:{cmd:hybrid}){p_end}
{synopt :{opt valueid:(label)}}string to precede the objective function value at each iteration (default:{cmd:Log-likelihood = }){p_end}
{synopt :{opt oim:(off|on)}}whether to use the OIM ({cmd:on}) or EIM({cmd:off}) variance estimator (default:{cmd:on}); this option is ignored for versions less than 1.0.0{p_end}

{syntab:Initial}
{synopt :{opt null}}requests that a null model be estimated; this effectively changes the covariate list to null and the constant to on, i.e., {cmd:x() cons(on)} for the first/mu parameter{p_end}
{synopt :{opt dist(gmssname)}}gmssname(s) of the associated distributions ({it:required}){p_end}
{synopt :{opt opt:im(gmssname)}}specifies the set of optimization options to assume{p_end}
{synopt :{opt title:(title)}}title to print out at the start of the iteration log; default is not to print anything{p_end}

{syntab:Run}
{synopt :{opt nolo:g}}specifies that the iteration log be suppressed{p_end}
{synopt :{opt nohea:der}}specifies that the informative table not be included in the results{p_end}
{synopt :{opt notab:le}}specifies that the coefficient table not be printed{p_end}
{synopt :{opt nowarn:ing}}specifies that the coefficient table not be printed{p_end}

{marker distname}{...}
{pstd}
Information on distribution names ({it:distnames}) is provided in the following table.  Note that there are no abbreviations allowed when specifying these names.

{center:               Number   Count(C)                                                               }
{center:Distribution     of     Binom(B)                                               Default         }
{center:Name           Links    Dist.   Range        Description                       Link(s)         }
{center:{hline 96}}
{center:{cmd:bernoulli}         1             0,1          Bernoulli                         logit            }
{center:{cmd:beta}              2             (0,1)        Beta                              logit,logit      }
{center:{cmd:betabin}           2       B     0,...,n      Beta binomial                     logit,log        }
{center:{cmd:betanbin}          3       C     0,1,...      Beta negative binomial            log,log,log      }
{center:{cmd:binomial}          1       B     0,...,n      Binomial                          logit            }
{center:{cmd:borel}             1       C     0,1,...      Borel                             log              }
{center:{cmd:bplindley}         2       C     0,...        Bernoulli Poisson-Lindley         log,log          }
{center:{cmd:chisquare}         1             Re+          Chi square                        log              }
{center:{cmd:dbinomial}         2       B     0,...,n      Double binomial                   logit,log        }
{center:{cmd:delaporte}         3       C     0,1,...      Delaporte                         log,log,logit    }
{center:{cmd:dpoisson}          2       C     0,1,...      Double Poisson                    log,log          }
{center:{cmd:exponential}       1             Re+          Exponential                       log              }
{center:{cmd:fschulz}           1       C     0,1,...      Flory-Schulz                      logm2            }
{center:{cmd:gamma}             2             Re+          Gamma                             pow(-1),pow(2)   }
{center:{cmd:gbinomial}         2       B     0,...,n      Generalized binomial              logit,log        }
{center:{cmd:geometric}         1       C     0,1,...      Geometric                         log              }
{center:{cmd:gnbinomial2}       3       C     0,1,...      Generalized negative binomial 2   log,log,logm1    }
{center:{cmd:gplindley2}        2       C     0,1,...      Generalized Poisson-Lindley 2     log,log          }
{center:{cmd:gplindley3}        3       C     0,1,...      Generalized Poisson-Lindley 3     log,log,log      }
{center:{cmd:gpoisson1}         2       C     0,1,...      Generalized Poisson 1             log,atanh        }
{center:{cmd:gpoisson2}         2       C     0,1,...      Generalized Poisson 2             log,log          }
{center:{cmd:gwaring}           3       C     0,1,...      Generalized Waring                log,log,log      }
{center:{cmd:invgamma}          2             0,1,...      Inverse gamma                     log,log          }
{center:{cmd:invnormal}         2             0,1,...      Inverse Gaussian                  identity,log     }
{center:{cmd:logistic}          2             Re           Logistic                          identity,log     }
{center:{cmd:multinomial}       k             0,...,k      Multinomial                       log              }
{center:{cmd:nbinomial1}        2       C     0,1,...      Negative binomial 1               log,log          }
{center:{cmd:nbinomial2}        2       C     0,1,...      Negative binomial 2               log,log          }
{center:{cmd:nbinomialp}        3       C     0,1,...      Negative binomial P               log,log,identity }
{center:{cmd:normal}            2             Re           Normal                            identity,log     }
{center:{cmd:ordered}           k             Re           Ordered                           mlogit,...       }
{center:{cmd:ordered2}          k             Re           Ordered (hetogenous)              mlogit,...       }
{center:{cmd:pailamujia}        1       C     0,1,...      Poisson-Ailamujia                 log              }
{center:{cmd:pig}               2       C     0,1,...      Poisson inverse Gaussian          log,log          }
{center:{cmd:planck}            1       C     0,1,...      Planck                            log              }
{center:{cmd:plindley}          1       C     0,1,...      Poisson-Lindley                   log              }
{center:{cmd:pmirra}            2       C     0,1,...      Poisson-Mirra                     log,log          }
{center:{cmd:poisson}           1       C     0,1,...      Poisson                           log              }
{center:{cmd:pqlindley}         2       C     0,1,...      Poisson Quasi-Lindley             log,log          }
{center:{cmd:ptmex}             2       C     0,1,...      Poisson transmuted exponential    log,log          }
{center:{cmd:pxgd}              1       C     0,1,...      Poisson XGamma                    log              }
{center:{cmd:upa}               1       C     0,1,...      Uniform Poisson-Ailamujia         log              }
{center:{cmd:waring}            2       C     0,1,...      Waring                            log,log          }
{center:{cmd:yule}              1       C     0,1,...      Yule                              log              }

{center:{cmd:heaped}            k       *     0,1,...      Heaped                            log,...,log      }
{center:{cmd:naltered}          1             0,...,n      n-altered                         logit            }
{center:{cmd:ninflated}         1             0,...,n      n-inflated                        logit            }
{center:{cmd:ninflatedtau}      1             0,...,n      n-inflated(tau)                   identity         }
{center:{cmd:nmarginal}         1             0,...,n      n-inflated marginalized           logit            }
{center:{cmd:ntruncated}        0             0,...,n-1    n-truncated                       <none>           }
{center:{cmd:zeroaltered}       1             0,1,...      0-altered                         logit            }
{center:{cmd:zeroinflated}      1             0,1,...      0-inflated                        logit            }
{center:{cmd:zeroinflatedtau}   1             0,1,...      0-inflated(tau)                   identity         }
{center:{cmd:zeromarginal}      1             0,1,...      0-inflated marginalized           logit            }
{center:{cmd:zerotruncated}     0             1,...,n-1    0-truncated                       <none>           }
{center:{cmd:zeronaltered}      2             0,...,n      0/n-altered                       mlogit,mlogit    }
{center:{cmd:zeroninflated}     2             0,...,n      0/n-inflated                      mlogit,mlogit    }
{center:{cmd:zeroninflatedtau}  2             0,...,n      0/n-inflated(tau_0,tau_n)         identity,identity}
{center:{cmd:zeronmarginal}     2             0,...,n      0/n-inflated marginalized         mlogit,mlogit    }
{center:{cmd:zerontruncated}    0             1,...,n-1    0/n-truncated                     <none>           }

{p}A {it:distname} is the name of a GMSS distribution.  Usually, this is a single distribution name such as {cmd:poisson}.  
However, a {it:distname} for a {it:count distribution} can be modified as in {cmd:heaped poisson}, {cmd:zeroinflated poisson}, or even {cmd:zeroinflated heaped poisson}. 
The {it:distnames} {cmd:heaped}, {cmd:zeroaltered}, {cmd:zeroinflated}, {cmd:zeroinflatedtau}, {cmd:zeromarginal}, and {cmd:zerotruncated} 
are not used without a trailing {it:distname} of a count or binomial distribution. The {it:distnames} {cmd:naltered}, {cmd:ninflated}, 
{cmd:ninflatedtau}, {cmd:nmarginal}, and {cmd:ntruncated} are not used without a trailing {it:distname} of a binomial distribution.{p_end}

{marker distparm}{...}
{title:Distribution Parameters}
{pstd}
Information on distribution parameters ({it:distnames}) is provided in the following table.  Note that there are no abbreviations allowed when specifying distribution names and links.

{center:                   Parameter 1     Parameter 2     Parameter 3                         }
{center:                       m1              m2              m3                              }
{center:                           Def.            Def.            Def.                        }
{center:Name               Range   Link    Range   Link    Range   Link   Notes                }
{center:{hline 87}}
{center:{cmd:beta}               (0,1)   logit   (0,1)   logit                                       }
{center:{cmd:betabin}            (0,1)   logit   Re+     log                                         }
{center:{cmd:betanbin}           Re+     log     Re+     logit   Re+     log    Var=infinity if m2>=1}
{center:{cmd:binomial}           (0,n)   logit                                                       }
{center:{cmd:borel}              Re+     log                                                         }
{center:{cmd:bplindley}          Re+     log                                                         }
{center:{cmd:chisquare}          Re+     log                                                         }
{center:{cmd:dbinomial}          (0,n)   logit   Re+     log                                         }
{center:{cmd:delaporte}          Re+     log     Re+     log     (0,1)   logit                       }
{center:{cmd:dpoisson}           Re+     log                                                         }
{center:{cmd:exponential}        Re+     log                                                         }
{center:{cmd:fschulz}            Re+     log                                                         }
{center:{cmd:gamma}              Re+     log     Re+     log                                         }
{center:{cmd:gbinomial}          (0,n)   logit   Re+     log                                         }
{center:{cmd:geometric}          Re+     log                                                         }
{center:{cmd:gnbinomial2}        Re+     log     Re+     log     Re+     log                         }
{center:{cmd:gplindley2}         Re+     log     Re+     log                                         }
{center:{cmd:gplindley3}         Re+     log     Re+     log     Re+     log                         }
{center:{cmd:gpoisson1}          Re+     log     (-1,1)  atanh                                       }
{center:{cmd:gpoisson2}          Re+     log     Re+     log                                         }
{center:{cmd:gwaring}            Re+     log     (2,inf) logm2   Re+     log                         }
{center:{cmd:invgamma}           Re+     log     Re+     log                                         }
{center:{cmd:invnormal}          Re+     log     Re+     log                                         }
{center:{cmd:logistic}           Re      ident.  Re+     log                                         }
{center:{cmd:nbinomial1}         Re+     log     Re+     log                                         }
{center:{cmd:nbinomial2}         Re+     log     Re+     log                                         }
{center:{cmd:nbinomialp}         Re+     log     Re+     log     Re      ident.                      }
{center:{cmd:normal}             Re      ident.  Re+     log                                         }
{center:{cmd:ordered1}           Re+     log                                    Internal mlogit link }
{center:{cmd:ordered2}           Re+     log     Re+     log                    Internal mlogit link }
{center:{cmd:pailamujia}         Re+     log                                                         }
{center:{cmd:pig}                Re+     log                                                         }
{center:{cmd:planck}             Re+     log                                                         }
{center:{cmd:plindley}           Re+     log                                                         }
{center:{cmd:pmirra}             Re+     log     Re+     log                                         }
{center:{cmd:poisson}            Re+     log                                                         }
{center:{cmd:pqlindley}          Re+     log     Re+     log                                         }
{center:{cmd:ptmex}              Re+     log     Re+     log                                         }
{center:{cmd:pxgd}               Re+     log                                                         }
{center:{cmd:upa}                Re+     log                                                         }
{center:{cmd:waring}             Re+     log     Re+     log                                         }
{center:{cmd:yule}               Re+     logit                                  Var=infinity if m2>=1}


{marker distvar}{...}
{title:Distribution Variances}
{pstd}
Information on distribution variance is provided in the following table.  Note that there are no abbreviations allowed when specifying distribution names and links.

                                        
{center:Name               Mean  Var                                                         Notes                                     }
{center:{hline 128}}
{center:{cmd:beta}               m1    m2^2*m1*(1-m1)                                                                                         }
{center:{cmd:betabin}            m1    m1*(1-m1/n)*(1 + (n-1)*m2/(1+m2))                                                                      }
{center:{cmd:betanbin}           m1    m1*(1+m1*m3)*(1+m2/m3)/(1-m2)                               Var=infinity if m2>=1                      }
{center:{cmd:binomial}           m1    m1*(1-m1/n)                                                                                            }
{center:{cmd:borel}              m1    m1^3*(1-1/m1)                                                                                          }
{center:{cmd:bplindley}          m1    f(m1,m2)                                                    Overdispersion only; unstable if m1<m2     }
{center:{cmd:chisquare}          m1    2*m1                                                                                                   }
{center:{cmd:dbinomial}          m1    m1*(1-m1/n)*m2                                                                                         }
{center:{cmd:delaporte}          m1    m1 + m1^2*m2*(1-m3)^2                                                                                  }
{center:{cmd:dpoisson}           m1    m1*m2                                                       Mean and variance are approximate          }
{center:{cmd:exponential}        m1    m1^2                                                                                                   }
{center:{cmd:fschulz}            m1    m1*2/(m1+2)                                                                                            }
{center:{cmd:gamma}              m1    m1^2*m2^2                                                                                              }
{center:{cmd:gbinomial}          m1    m1*(1-m2*m1/n)*(1+(m2-1)*m1/n)                              Binomial if m2=0, negative binomial if m2=1}
{center:{cmd:geometric}          m1    m1*(1+m1)                                                                                              }
{center:{cmd:gnbinomial2}        m1    m1+m2*m1^m3                                                                                            }
{center:{cmd:gplindley2}         m1    m1+f(m1,m2)                                                 Overdispersion only; formula is complicated}
{center:{cmd:gplindley3}         m1    m1+f(m1,m2,m3)                                              Overdispersion only; formula is complicated}
{center:{cmd:gpoisson1}          m1    m1*m2                                                       Over/Under-dispersion                      }
{center:{cmd:gpoisson2}          m1    m1/m2                                                       Overdispersion only                        }
{center:{cmd:gwaring}            m1    f(m1,m2,m3)                                                 Overdispersion only; formula is complicated}
{center:{cmd:invgamma}           m1    m1^3*m2^2                                                                                              }
{center:{cmd:invnormal}          m1    m2^2                                                                                                   }
{center:{cmd:logistic}           m1    m2^2*pi^2/3                                                                                            }
{center:{cmd:nbinomial1}         m1    m1*m2                                                                                                  }
{center:{cmd:nbinomial2}         m1    m1*(1+m2*m1)                                                                                           }
{center:{cmd:nbinomialp}         m1    m1*(1+m1^(m3-1)/m2)                                                                                    }
{center:{cmd:normal}             m1    m2^2                                                                                                   }
{center:{cmd:ordered1}                                                                             Mean/var functions of all links            }
{center:{cmd:ordered2}                                                                             Mean/var functions of all links            }
{center:{cmd:pailamujia}         m1    m1+0.5*m1^2                                                                                            }
{center:{cmd:pig}                m1    m1+m2*m1^2                                                                                             }
{center:{cmd:planck}             m1    m1+m1^2                                                                                                }
{center:{cmd:plindley}           m1    m1*(1+m1*f(m1))                                             Overdispersion only; formula is complicated}
{center:{cmd:pmirra}             m1    f(m1,m2)                                                    Overdispersion only; formula is complicated}
{center:{cmd:poisson}            m1    m1                                                                                                     }
{center:{cmd:pqlindley}          m1    m1(1+f(m2)*m1)                                              f(m2)->.5 as m2->0, f(m2)->1 as m2->inf    }
{center:{cmd:ptmex}              m1                                                                                                           }
{center:{cmd:pxgd}               m1    f(m1)                                                       Overdispersion only; formula is complicated}
{center:{cmd:upa}                m1    m1*(1+m1)                                                                                              }
{center:{cmd:waring}             m1    f(m1,m2)                                                                                               }
{center:{cmd:yule}               m1    m1*(m1+1)^2/(1-m1)                                          Var=infinity if m1>=1                      }



{marker linkname}{...}
{pstd}
Information on link names ({it:linknames}) is provided in the following table.  Note that there are no abbreviations allowed when specifying these names.

{center:Link                                                }
{center:Name            Range      Description              }
{center:{hline 52}}
{center:{cmd:atanh}           (-1,1)     Hyperbolic arc-tangent   }
{center:{cmd:cauchit}         (0,1)      Cauchit                  }
{center:{cmd:cloglog}         (0,1)      Complementary log-log    }
{center:{cmd:halflogit}       (0,2)      Half logit               }
{center:{cmd:identity}        Re         Identity                 }
{center:{cmd:log}             Re+        Log                      }
{center:{cmd:logcomplement}   (0,1)      Log complement           }
{center:{cmd:logcorr}         (-1,1)     Log correlation          }
{center:{cmd:logm1}           [1,inf)    Log minus 1              }
{center:{cmd:logm2}           [2,inf)    Log minus 2              }
{center:{cmd:logit}           (0,1)      Logit                    }
{center:{cmd:loglog}          (0,1)      Log-log                  }
{center:{cmd:nbinomial}       Re+        Negative binomial        }
{center:{cmd:power2}          Re+        Power(2) = squared       }
{center:{cmd:powerm2}         Re+        Power(-2)                }
{center:{cmd:probit}          (0,1)      Probit                   }
{center:{cmd:reciprocal}      Re         Reciprocal = Power(-1)   }


{marker description}{...}
{title:Description}

{pstd}
{cmd:gmss} facilitates the specification and estimation of regression models.  There is similarity to the GAMLSS package for R users in that a 
large collection of models can be estimated in either package.  GAMLSS allows specification of additive terms for each parameter, and that is still in the development
stage for GMSS.  GAMLSS also supports some distributions that we have either not yet developed, or have elected to ignore (e.g., if the distribution does
not have a parameterization for which there is a single parameter reflecting the expected outcome). Likewise, GMSS supports some distributions that
are not part of GAMLSS.

{pstd}
The generalized model specification system utilizes a large {help mata} library of distribution and link classes
to define regression models and then utilizes {help moptimize} for estimation.  Using {help char}, the system stores specifications with the dataset; 
see {findalias frchars} for more details.  There were four goals in the development of GMSS:{p_end}

{phang}
1. To develop a library of mata classes for the estimation of parametric regression models.  The target was any distribution for which there was a mean parameter.  
To that end, {browse "http://www.stata-press.com/books/mata-book/":{it:The Mata Book}} by William Gould was essential. The GMSS mata library defines distributions in terms
of parameters and then parameters are described in terms of link functions.  This separation (which is reflected in the documentation for {help moptimize}) then allowed generic
construction of evaluator programs that specify calculations in terms of the chain rule.  Specifically, we had the goal of opening up access to all of the options of Stata's
premier optimization routine and, so, interested users should consult {help moptimize} for details.

{phang}
2. To ensure that the developed library could be expanded to include additive components.  These are not currently included in GMSS, but see {help npregress_series:npregress} 
for details.  We do not currently have a timeline for this development as it will likely require cooperation with Stata Corp; that is, we would benefit tremendously from 
the development of new mata functions for which Stata Corp is in a much better position.

{phang}
3. To facilitate the construction of more sophisticated models using GMSS components as building blocks.  This is evidenced, for example, zero-inflated models.  
Because a zero-inflated model is a mixture of a Bernoulli plus a count distribution, we could then develop a generic zero-inflation wrapper that then supports 
any/all count distributions.  This is also true for zero-inflated tau which is the second form discussed in Lambert's paper for which the inflation is assumed 
to be a scale factor (tau) times the linear predictor in the count distribution.  Subsequently, we developed generic wrappers for zero-truncated models, 
zero-marginalized models, and zero-altered models.  Similarly, we developed a wrapper to allow estimation of heaped outcomes that support all count 
distributions. Thus, each count distribution can be estimated in 12 different ways: as-is, zero-inflated, zero-inflated tau, zero-altered, 
zero-marginalized, zero-truncated, heaped, zero-inflated heaped, zero-inflated tau heaped, zero-altered heaped, zero-marginalized heaped, zero-truncated heaped.

{phang}
4. To provide the opportunity for us to work together (at least once) in our professional lives.  Thus, this project was envisioned and then developed as part of 
the first author's sabbatical project.


{marker remarks}{...}
{title:Remarks}
{* 25 count distributions = 300 models + 8 models}
{pstd}
The current state of the GMSS system is that it is a functional system.  Due to its size (supporting several hundred regression models), 
testing and validation is an ongoing project.  Similarly, development has thus far been driven by utility.  
That is, the system is meant to operate correctly/accurately, and it has not been optimized for size (memory usage) or speed.  An estimation 
command developed by Stata Corporation typically includes estimation of a null model and, sometimes, estimation of additional comparable models.  Such practice facilitates 
the inclusion of an omnibus test in the header of the output as well as the construction of starting values to improve convergence properties of the full model.
The GMSS makes no such attempts other than to facilitate estimation of a null model.  Utilizing null model results as starting values in GMSS is left to the user
as part of the specification of the model's link functions.

{pstd}
Generally, estimation commands developed by Stata Corp are going to be slightly faster than equivalent models in GMSS (assuming d2 evaluator types). This is partially
due to Stata Corp's better starting values, and partially due to the efficiency gains of model-specific development.  The latter is exemplified by considering the 
calculation of the gradient for Poisson regression.  The derivative of the log-likelihood with respect to the mean parameter is (y-mu)/mu.  Stata 
(and nearly everyone else; it's the default link in GMSS) uses
the log-link for the mean parameter and so the derivative with respect to the linear predictor is (y-mu)/mu * mu, using the chain rule.  Thus, Stata's {help poisson} command 
calculates the gradient using y-mu.  The GMSS, however, allows specification of any link function, and so, has no opportunity to simplify the chain rule specification.  Thus, the GMSS 
has a cost of an additional division and an additional multiplication over Stata's routine in this particular example.

{pstd}
GMSS will likely be faster than ado-coded user-written estimation commands, and will include models that are otherwise unavailable.  GMSS increases access 
to the different evaluators in Stata's optimization library.

{pstd} 
Here is the mata routine for maximization using any of the {cmd:d*} evaluators{p_end}

    {cmd:void function GMSS_ml(transmorphic M, real scalar todo, real rowvector b, | fv, g, H)} {cmd:{c -(}}             
        {cmd:real                            scalar u, v}
        {cmd:pointer(struct GMSS)            scalar gmss}
        {cmd:pointer(class GMSS_Dist scalar) scalar dist}

        {cmd:// GMSS optimization function called by moptimize() for types: d0, d1, d2, d1debug, d2debug}

        {cmd:gmss = findexternal(moptimize_util_userinfo(M, 1))}
        {cmd:dist = gmss->dist}
        {cmd:dist->load(M, b)}
        {cmd:dist->update_pars()                        // Calculate theta = ginv(p) for each p}
        {cmd:if(dist->hasc) dist->updateC(todo)         // Update normalization factor if necessary}
        {cmd:fv = moptimize_util_sum(M, dist->loglik()) // Calculate the log-likelihood}

        {cmd:if (todo==0 | missing(fv)) return}
        {cmd:if (todo > 0)} {cmd:{c -(}}{cmd:                            // Calculate the gradient vector}
            {cmd:for(u=1;u<=dist->m;u++) } {cmd:{c -(}}
                {cmd:g[|moptimize_util_eq_indices(M, u)|] =} 
                    {cmd:moptimize_util_vecsum(M, u, dist->dldpar(u):*dist->dpar(u), fv)} 
            {cmd:{c )-}}
        {cmd:{c )-}}

        {cmd:if (todo==1 | missing(g)) return}
        {cmd:if (todo > 1) } {cmd:{c -(}}{cmd:                           // Calculate the Hessian}
            {cmd:for(v=1; v<=dist->m; v++) } {cmd:{c -(}}
                {cmd:H[|moptimize_util_eq_indices(M, v, v)|] =} 
                    {cmd:moptimize_util_matsum(M, v, v, dist->d2ldpar2(v,v):*dist->dpar(v):*dist->dpar(v) :+} 
                        {cmd:dist->dldpar(v):*dist->d2par(v), fv)} 
                {cmd:for(u=v+1; u<=dist->m; u++) } {cmd:{c -(}}
                    {cmd:H[|moptimize_util_eq_indices(M, u, v)|] =} 
                        {cmd:moptimize_util_matsum(M, u, v, dist->d2ldpar2(u,v):*dist->dpar(u):*dist->dpar(v), fv)} 
                {cmd:{c )-}}
            {cmd:{c )-}}
            {cmd:_makesymmetric(H)}
        {cmd:{c )-}}
    {cmd:{c )-}}

	
{pstd}
To be clear, this is the only evaluation function that there is for all of the supported models.  We moved the 
calculations of the specifics into the class objects for distributions and links. The {cmd:GMSS} struct contains
a pointer to the optimization struct returned by {cmd:moptimize_init()} and a pointer to the distribution instance 
(which contains a pointer to a vector of link instances).    The only additional complexity in this function from 
what is described in mata's documentation is that we alert the distribution object to calculate its normalization
factor if necessary (though important, very few distributions need this).

{pstd}
Our motivation in developing the library was that the simplification in terms of evaluator development 
would be worth the efficiency cost of relying on the chain rule.	

{marker results}{...}
{title:Stored results}

{pstd}
{cmd: gmss run} stores the following in {cmd:e()}:

{synoptset 23 tabbed}{...}
{p2col 5 23 26 2: Scalars}{p_end}
{synopt:{cmd:e(nrtol)}}{it:nrtol} tolerance criterion for g*syminv(H)*g'{p_end}
{synopt:{cmd:e(vtol)}}{it:vtol} tolerance criterion for relative change in log-likelihood(function) value{p_end}
{synopt:{cmd:e(ptol)}}{it:ptol} tolerance criterion for relative change in coefficient vector{p_end}
{synopt:{cmd:e(maxiter)}}maximum number of iterations allowed{p_end}
{synopt:{cmd:e(ll)}}final value of log-likelihood{p_end}
{synopt:{cmd:e(ll0)}}initial value of log-likelihood (which may not be related to the null model){p_end}
{synopt:{cmd:e(niter)}}number of iterations performed{p_end}
{synopt:{cmd:e(converged)}}{cmd:1} if converged, {cmd:0} otherwise{p_end}
{synopt:{cmd:e(N)}}number of observations{p_end}
{synopt:{cmd:e(k)}}number of coefficients{p_end}
{synopt:{cmd:e(k_dv)}}number of dependent variables{p_end}
{synopt:{cmd:e(k_eq)}}number of equations/links in overall model{p_end}
{synopt:{cmd:e(rank)}}rank of {cmd:e(V)}{p_end}
{synopt:{cmd:e(rc)}}return code{p_end}

{p2col 5 23 26 2: Macros}{p_end}
{synopt:{cmd:e(oim)}}{cmd:1} if OIM, {cmd:0} EIM{p_end}
{synopt:{cmd:e(valueid)}}string to precede function value in iteration log; default:{cmd:Log-likelihood =}{p_end}
{synopt:{cmd:e(singular)}}{cmd:hybrid} or {cmd:m-marquardt} indicating technique to use if hessian is singular{p_end}
{synopt:{cmd:e(random)}}{cmd:on} if starting values include random search, {cmd:off} otherwise{p_end}
{synopt:{cmd:e(search)}}{cmd:on} if there was a search for starting values, {cmd:off} otherwise{p_end}
{synopt:{cmd:e(ignorenrtol)}}{cmd:on} if {it:nrtol} was ignored in evaluating convergence, {cmd:off} otherwise{p_end}
{synopt:{cmd:e(warning)}}{cmd:on} if warning is issued if convergence failed, {cmd:off} otherwise{p_end}
{synopt:{cmd:e(svy)}}{cmd:on} if warning is issued if convergence failed, {cmd:off} otherwise{p_end}
{synopt:{cmd:e(tracevalue)}}{cmd:on} if log-likelihood(function) value is printed at the beginning of each iteration, {cmd:off} otherwise{p_end}
{synopt:{cmd:e(tracelevel)}}the output to be displayed during the optimization{p_end}
{synopt:{cmd:e(technique)}}the technique to be used to find the coefficient vector{p_end}
{synopt:{cmd:e(evaluator)}}the style of evaluator used{p_end}
{synopt:{cmd:e(mataname)}}the name in which estimates are stored; default is {cmd:GMSS}{p_end}
{synopt:{cmd:e(moptname)}}the name of the {cmd:moptimize_init()} struct used for estimation; this can be used as the {cmd:M} 
argument to access results in mata via the {cmd:moptimize_result_*()} functions.{p_end}
{synopt:{cmd:e(optim)}}the {it:gmssname} of stored optimization options or {cmd:default} if none specified at run time{p_end}
{synopt:{cmd:e(runarg)}}the {it:gmssnames} of the distribution(s) specified at run time{p_end}
{synopt:{cmd:e(title)}}the title in the header of the output created from distribution names{p_end}
{synopt:{cmd:e(GMSS)}}the name of the mata GMSS struct containing the information on the model{p_end}
{synopt:{cmd:e(cmd)}}the name of the command ({cmd:gmss}){p_end}
{synopt:{cmd:e(estat_cmd)}}the name ({cmd:GMSS_estat}) of the post-estimation command for {cmd:estat}{p_end}
{synopt:{cmd:e(predict)}}the name ({cmd:GMSS_pred}) of the post-estimation command for {cmd:predict}{p_end}
{synopt:{cmd:e(deriv_useminbound)}}{cmd:on} if optimization used user-specified minimum bounds, {cmd:off} otherwise{p_end}
{synopt:{cmd:e(opt)}}the optimization routine ({cmd:moptimize}){p_end}
{synopt:{cmd:e(user)}}the mata optimization routine: {cmd:GMSS_ml} if evaluator is {cmd:d*}, 
{cmd:GMSS_lfdef} if evaluator is {cmd:lf}, and {cmd:GMSS_mllf} if evaluator is {cmd:lf*}{p_end}
{synopt:{cmd:e(ml_method)}}the evaluation method{p_end}
{synopt:{cmd:e(which)}}{cmd:max} if maximization, {cmd:min} otherwise{p_end}
{synopt:{cmd:e(depvar)}}the name of the dependent variable{p_end}
{synopt:{cmd:e(properties)}}{cmd:b V}{p_end}
{synopt:{cmd:e(version)}}{cmd:Major#.Minor#.Patch#} is the version number of the library (currently set to 0.8.0){p_end}


{p2col 5 23 26 2: Matrices}{p_end}
{synopt:{cmd:e(b)}}row vector of the estimated regression coefficients{p_end}
{synopt:{cmd:e(b}{it:#}{cmd:)}}row vector of the estimated regression coefficients for equation {it:#}{p_end}
{synopt:{cmd:e(V)}}estimated variance matrix{p_end}
{synopt:{cmd:e(ilog)}}vector of the iteration log{p_end}
{synopt:{cmd:e(gradient)}}final calculated gradient vector{p_end}

{p2col 5 23 26 2: Functions}{p_end}
{synopt:{cmd:e()}}{p_end}

{marker postestimation}{...}


{marker version}{...}
{title:Versions}
{pstd}
Note that the library follows semantic version numbering for which the full version
number is constructed with a MAJOR.MINOR.PATCH set of numbers.{p_end}

{pstd}Changes in major versions may break API calls, changes in minor versions 
signify backward-compatible changes, and changes in patch number signify 
bug fixes.{p_end}

{pstd}Any version number that 
begins with zero should be viewed as a beta version.  Given that the library allows access to all of Stata's
evaluator functions, users are encouraged to estimate models using the {cmd:d1debug}, {cmd:d2debug}, {cmd:lf1debug},
and {cmd:lf2debug} evaluators.  When using the debug optimization evaluators, Stata will rely on numeric derivatives
rather than the analytic derivatives in the library.  Users are also encouraged to specify {cmd: tracelevel(hessian)}
(in the list of optimization options) to see a report on the comparisons of analytic and numeric derivatives.{p_end}

{pstd} {cmd:0.8.0} is the initial beta version of the {cmd:lgmss.mlib} library of mata functions and 
ado-files ({cmd:gmss.ado}, {cmd:gmss2stage.ado}, {cmd:GMSS_estat.ado}, {cmd:GMSS_pred}).  This version of
the library does not include documentation of the mata library. Support for user-written additions to the 
library will be incorporated in future versions.  Extensions of the mata classes will also be developed to 
admit additional types of regression models.

{marker authors}{...}
{title:Authors}

James  W. Hardin (jhardin@sc.edu)
Taylor A. Hardin
Conner D. Hardin

{pstd}
JWH (biostatistics professor) is responsible for the Stata/Mata coding and is the principal author of the documentation.  
TAH (software engineer) is responsible for parts of the software design and all of the Github functionality.  
CDH (sound design) is responsible for the graphics, parts of the software design, and the YouTube video files in support of this project.

{marker orefs}{...}
{title:Online References}

{phang}
{browse "https://www.youtube.com/@biostatdoc/":YouTube Channel for video help and demonstrations}

{phang}
{browse "https://www.github.com/jwhardin/BiostatDoc/":Github repository for the library, examples, and additional documentation}

{marker prefs}{...}
{title:Programming References}

{phang}
Gould, William. 2018
{browse "http://www.stata-press.com/books/mata-book/":The Mata Book}
College Station, TX: StataPress.

{phang}
Hardin, James W., Hardin, Taylor A., and Hardin, Conner D. Forthcoming.
A Generalized Model Specification System,
The Stata Journal.

{phang}
Pitblado, Jeffrey, Poi, Brian, and Gould, William. 2024
{browse "http://www.stata-press.com/books/maximum-likelihood-estimation-stata/":Maximum Likelihood Estimation with Stata, Fifth Edition}
College Station, TX: StataPress.

{marker refs}{...}
{title:References}

{phang}
Ahmadini, Abdullah Ali H., Ahsan-ul-Haq, Muhammad, 
Hussain, Muhammad Nasir Saddam. 2024.
A new two-parameter over-dispersed discrete distribution with
mathematical properties, estimation, regression model
and applications.
Heliyon, 10.
doi:10.1016/j.heliyon.2024.e36764

{phang}
Aljohani, Hassan M., Akdogan, Yunus, Cordeiro, Gauss M., and Afify, Ahmed Z. 2021.
The Uniform Poisson–Ailamujia Distribution: Actuarial
Measures and Applications in Biological Science.
Symmetry, 13, 1258.
doi:10.3390/sym13071258

{phang}
Alrumayh, Amani, and Khogeer, Hazar A. 2023.
A New Two-Parameter Discrete Distribution for Overdispersed
and Asymmetric Data: Its Properties, Estimation, Regression
Model, and Applications.
Symmetry, 15, 1289.
doi:10.3390/sym15061289

{phang}
Altun, E. 2019.
A New Model for Over-Dispersed Count Data: Poisson Quasi-Lindley Regression Model. 2019.
Mathematical Sciences 13, 241-247.
doi:10.1007/s40096-019-0293-5

{phang}
Altun, Emrah, Alqifari, Hana, and Eliwa, Mohamed S. 2023.
A novel approach for zero-inflated count regression model: Zero-inflated
Poisson generalized-Lindley linear model with applications
AIMS Mathematics, 8(10): 23272–23290.
doi:10.3934/math.20231183

{phang}
Atikankul, Yupapin.  2023.
A New Poisson Generalized Lindley Regression Model
Austrian Journal of Statistics
January 2023, Volume 52, 3950.
doi:10.17713/ajs.v52i1.1344

{phang}
Bakouch, Hassan S., Chesneau, Christophe, Maya, Radhakumari, Irshad, Muhammed Rasheed,
Aswathy, Sreedeviamma, and Qarmalah, Najla. 2023.
A Flexible Dispersed Count Model Based on Bernoulli
Poisson–Lindley Convolution and Its Regression Model. Axioms, 12, 813.  
doi:10.3390/

{phang}
Bertoli, W., Conceicao, K. S., Andrade, M.G., and Louzada, F. 2019.
Bayesian Approach for the Zero-Modified Poisson-Lindley Regression Model.
Brazilian Journal of Probability and Statistics 33 (4), 826-860.
doi:10.1214/19-BJPS447

{phang}
Dean, C., Lawless, J.F., and Willmot, G.E. 1989.
A Mixed Poisson-Inverse-Gaussian Regression Model.  
The Canadian Journal of Statistics, 17 (2), 171-181.

{phang}
Ebraheim, A.H.N., Mohamed, S. M., Muayw, K.A. 2022.
A New Regression Model for Poisson Lindfley Distribution with Applications.
Commun. Math. Biol. Neurosci. 74.
doi:10.28919/cmbn/7374

{phang}
Guneri, O.I., and Durmus, B. 2021.
Models for Overdispersion Count Data with Generalized Distribution: An Application to Parasites Intensity.
Journal of New Theory, 35(2021), 48-61.

{phang}
Hall, D.B. 2000.
Zero-Inflated Poisson and Binomial Regression with Random Effects: A Case Study.
International Biometric Society, 56(4), 1030-1039.

{phang}
Irwin, J.O. 1975.
The Generalized Waring Distribution. Part I.
Journal of the Royal Statistical Society. Series A. 138(1), 18-31.

{phang}
Lambert, D. 1992.
Zero-Inflated Poisson Regression with an Application to Defects in Manufacturing.
Technometrics 34(1), 1-14.

{phang}
Maya, Radhakumari, Irshad, Muhammed Rasheed, Chesneau, Christophe, Nitin, Soman Latha, 
and Shibu, Damodaran Santhamani. 2022. 
On Discrete Poisson–Mirra Distribution: Regression, INAR(1)
Process and Applications.
Axioms, 11, 189.
doi:10.3390/axioms11050193

{phang}
Nadaraj, S., Bakouch, H.S., and Tahmasbi, R. 2011.
A Generalized Lindley Distribution.
Sankyha: Thge Indian Journal of Statistics, Series B, 73(2), 331-359.

{phang}
Pararai, M., Warahena-Liyanage, G., and Oluyede, B.O. 2015.
Extended Lindley Poisson Distribution.
Journal of Mathematics and Statistical Science, 1 (5), 167-198.

{phang}
Wongrin, W. and Bodhisuwan, W. 2016.
Generalized Poisson-Lindley linear model for Count Data.
Journal of Applied Statistics, 44(15), 2659-2671.
doi:10.1080/02664763.2023.1260095
