*! version 0.8.0  20march2025
program define gmss2stage, eclass	sortpreserve
	version 19.0
	
	syntax anything [, zhat(string) *]
	
	quietly {
		if "`zhat'" == "" {
			noi di as err "zhat() not specified with the stage-1 covariate used in stage-2"
			exit 198
		}
		
		local nw : word count `anything'
		if `nw' != 2 {
			noi di as err "incorrect number of arguments: must supply stage-1 and stage-2 gmssnames"
			exit 198
		}
		
		local stage1 : word 1 of `anything'
		local stage2 : word 2 of `anything'
		
		gmss run `stage1'
		local m1 = e(k_eq) // after estimation
		local ncoefs1 = colsof(e(b))
		tempname V1 V1s
		matrix `V1' = e(V)
		
		local cc1 : colnames(e(b))
		local cc1 = index("`cc1'", "_cons")

		gmss run `stage2'
		local m2 = e(k_eq) // after estimation
		local ncoefs2 = colsof(e(b))
		tempname beta
		scalar `beta' = _b[`zhat']
		tempname V2 V2s
		matrix `V2' = e(V)
		
		local cc2 : colnames(e(b))
		local cc2 = index("`cc2'", "_cons")

		tempvar cons zero
		gen byte `cons' = 1
		gen byte `zero' = 0
		
		if `cc1' > 0 {
			local cons1 "`cons'"
		}
		if `cc2' > 0 {
			local cons2 "`cons'"
		}

		tempname rtmp  rrow  rmat 
		tempname ctmp  crow  cmat 
		tempname cstmp csrow csmat cstm2

		tempvar dldeta2_1 dmu2_1
		predict double `dldeta2_1', dldeta gmss(`stage2') eqnum(1)
		predict double `dmu2_1'   , dldmu  gmss(`stage2') eqnum(1)

		forvalues u=1/`m1' {
			tempvar dldmu1 dldeta1 dmu1 
			predict double `dldmu1'  , dldmu   gmss(`stage1') eqnum(`u')
			predict double `dldeta1' , dldeta  gmss(`stage1') eqnum(`u')
			predict double `dmu1'    , dmu     gmss(`stage1') eqnum(`u')
			
			mata: GMSS_result_eq_colnames("xlist1", "`cons1'", `stage1', `u')
			local n1 : word count `xlist1'

			forvalues v=1/`m2' {
				tempvar dldmu2 dldeta2 dmu2 d2ldmu2
				predict double `dldmu2'  , dldmu   gmss(`stage2') eqnum(`v')
				predict double `dldeta2' , dldeta  gmss(`stage2') eqnum(`v')
				predict double `dmu2'    , dmu     gmss(`stage2') eqnum(`v')
				predict double `d2ldmu2' , d2ldmu2 gmss(`stage2') eqnum(`v' 1) 

				mata: GMSS_result_eq_colnames("xlist2", "`cons2'", `stage2', `v')
				local n2 : word count `xlist2'
				
				local zxlist2
				local nv : word count `xlist2'
				forvalues k=1/`nv' {
					local vv : word `k' of `xlist2'
					if "`vv'" != "`zhat'" {
						local zxlist2 `zxlist2' `zero'
					}
					else {
						local zxlist2 `zxlist2' `vv'
					}
				}
				
				matrix accum `rtmp'  = `xlist1' `xlist2'  [iw=(`dldeta2'*`dldeta1')], nocons
				matrix accum `ctmp'  = `xlist1' `xlist2'  [iw=(`dldeta2'*`dldeta2_1'*`dmu1'*`beta')], nocons
				matrix accum `cstmp' = `xlist1' `xlist2'  [iw=(`u'==1)*(`d2ldmu2'*`dmu2_1'*`dmu2'*`dmu1'*`beta') + ///
																(`u'==1 & `v'==1)*(`dldmu2'*`dmu2'*`dmu1'*`beta')], nocons
				matrix accum `cstm2' = `xlist1' `zxlist2' [iw=(`u'==1 & `v'==1)*(`dldmu2')], nocons
				matrix `cstmp' = `cstmp' + `cstm2'
				
				// Keep appropriate submatrix
				local a1 = `n1'+1
				local a2 = `n1'+`n2'
				local b2 = `n1'
				mat `rtmp'  =  `rtmp'[`a1'..`a2',1..`b2']
				mat `ctmp'  =  `ctmp'[`a1'..`a2',1..`b2']
				mat `cstmp' = `cstmp'[`a1'..`a2',1..`b2']

				if (`v'==1) {
					mat `rrow'  = `rtmp'
					mat `crow'  = `ctmp'
					mat `csrow' = `cstmp'
				}
				else {
					mat `rrow'  = `rrow' \ `rtmp'
					mat `crow'  = `crow' \ `ctmp'
					mat `csrow' = `csrow'\ `cstmp'
				}
			}
			if (`u'==1) {
				mat `rmat'  = `rrow'
				mat `cmat'  = `crow'
				mat `csmat' = `csrow'
			}
			else {
				mat `rmat'  = `rmat'  , `rrow'
				mat `cmat'  = `cmat'  , `crow'
				mat `csmat' = `csmat' , `csrow'
			}
		}

		matrix R   = `rmat'
		matrix C   = `cmat'
		matrix Cs  = `csmat'
		matrix V1  = `V1'
		matrix V2  = `V2'
		matrix MT  = V2  + (V2 * (C*V1*C'    - R*V1*C'  - C*V1*R')  * V2)
		*matrix MTs = V2s + (V2 * (Cs*V1s*Cs' - R*V1*Cs' - Cs*V1*R') * V2)
		
		matrix mt = MT
		
		ereturn matrix R     = R
		ereturn matrix C     = C
		ereturn matrix Cs    = Cs
		ereturn matrix V_MT  = mt
		ereturn matrix V_oim = V2

		ereturn repost V = MT
		ereturn local vcetype "MTopel"
		noi gmss results `stage2',  `options'
	}
end
