{smcl}
{* *! version 0.8.0  07march2025}{...}
{viewerjumpto "Syntax" "gmss2stage##syntax"}{...}
{viewerjumpto "Options" "gmss2stage##options"}{...}
{viewerjumpto "Distribution names" "gmss2stage##distname"}{...}
{viewerjumpto "Distribution Parameters" "gmss_dist##distparm"}{...}
{viewerjumpto "Distribution Variances" "gmss_dist##distvar"}{...}
{viewerjumpto "Link names" "gmss2stage##linkname"}{...}
{viewerjumpto "Description" "gmss2stage##description"}{...}
{viewerjumpto "Remarks" "gmss2stage##remarks"}{...}
{viewerjumpto "Stored Results" "gmss2stage##results"}{...}
{viewerjumpto "Version" "gmss2stage##version"}{...}
{viewerjumpto "Authors" "gmss2stage##authors"}{...}
{viewerjumpto "References" "gmss_dist##refs"}{...}

{p2colset 1 15 19 2}{...}
{p2col:{bf:gmss2stage} {hline 2}} Two stage estimation using GMSS{p_end}
{p2colreset}{...} 


{marker syntax}{...}
{title:Syntax}

{p 8 16 2}
gmss2stage {it:stage1} {it:stage2} , zhat(varname) [ ]


{marker options}{...}
{title:Options}

{p2colset 1 15 19 2}
{p2col:{it:stage1}} the first stage model (the name of the GMSS model)

{p2col:{it:stage2}} the second stage model (the name of the GMSS model)

{p2col:{it:zhat}} the name of the variable holding the stage 1 predictions that is used as a covariate in the second stage model.

{marker description}{...}
{title:Description}

{pstd}
This command is built using the the {cmd:gmss} command for estimating regression models.  It calculates the Murphy-Topel
variance estimator as the default and posts that matrix to the stored results before display.

{marker examples}{...}
{title:Examples}

These examples are the ones found in the A.R. Hole reference cited at the end of this help file.

{text}
sysuse greene, clear	                // Load data
gen byte mdrgt0 = cond(mdr==.,.,mdr>0)	// Binary version of the count
gen mdr3lvl = mdr + 1
replace mdr3lvl = 3 if mdr3lvl>3        // 3-level version of the count	

// Clear the GMSS system and define a set of optimization options
gmss clear 
gmss opt d2, evaluator(d2) maxiter(40) search(on)

// Stage 1
local opt_opts d2                       // GMSS optimization options

local y1 acc                            // Stage 1: dependent variable
local x1 age income ownrent selfemp     // Stage 1, Parm 1: covariates


// Stage 1 - Logit
gmss link acc_logit , y(`y1') x(`x1') name(logit)
gmss dist logit     , name(bernoulli) link(acc_logit)
gmss init s1_logit  , dist(logit) opt(`opt_opts') nowarning
gmss run  s1_logit  , nolog noheader notable 			
predict double mu_logit

// Stage 1 - Probit
gmss link acc_probit, y(`y1') x(`x1') name(probit)
gmss dist probit    , name(bernoulli) link(acc_probit)
gmss init s1_probit , dist(probit) opt(`opt_opts') nowarning
gmss run  s1_probit , nolog noheader notable 			
predict double mu_probit

// Stage 1 - Regress
gmss link acc_reg   , y(`y1') x(`x1') name(identity)
gmss link sigma     , name(log)
gmss dist reg       , name(normal) link(acc_reg sigma)
gmss init s1_reg    , dist(reg) opt(`opt_opts') nowarning
gmss run  s1_reg    , nolog noheader notable 			
predict double mu_reg


// Stage 2
local y2_cnt   mdr
local y2_bin   mdrgt0
local y2_3lvl  mdr3lvl
local x2 age income avgexp

gmss link mdr_logl   , y(`y2_cnt')  x(`x2' mu_logit)  name(log)
gmss link mdr_logp   , y(`y2_cnt')  x(`x2' mu_probit) name(log)
gmss link mdr_logr   , y(`y2_cnt')  x(`x2' mu_reg)    name(log)
gmss link mdr_bin    , y(`y2_bin')  x(`x2' mu_logit)  name(probit)
gmss link mdr_prob3  , y(`y2_3lvl') x(`x2' mu_probit) cons(off) name(probit)

gmss link sigma      , cons(on) name(log)  
gmss link k1         , cons(on) name(identity) label(_cut1)
gmss link k2         , cons(on) name(identity) label(_cut2)

// Example 1
gmss dist poisson    , name(poisson) link(mdr_logl)
gmss init s2_ex1     , dist(poisson) opt(`opt_opts') nowarning
gmss2stage s1_logit s2_ex1, zhat(mu_logit) `header'


// Example 2
gmss run s2_ex1      , nolog `header'

// Example 3
gmss dist bernoulli  , name(bernoulli) link(mdr_bin)
gmss init s2_ex3     , dist(bernoulli) opt(`opt_opts') nowarning
gmss2stage s1_logit s2_ex3, zhat(mu_logit) `header'

// Example 4
gmss dist poisson    , name(poisson) link(mdr_logp)
gmss init s2_ex4     , dist(poisson) opt(`opt_opts') nowarning
gmss2stage s1_probit s2_ex4, zhat(mu_probit) `header'

// Example 5 : Note we do ML Gaussian regression (differs from citation)
gmss dist poisson    , name(poisson) link(mdr_logr)
gmss init s2_ex5     , dist(poisson) opt(`opt_opts') nowarning
gmss2stage s1_reg s2_ex5, zhat(mu_reg) `header'

// Example 6
gmss dist nbin2      , name(nbinomial2) link(mdr_logl sigma)
gmss init s2_ex6     , dist(nbin2) opt(`opt_opts') nowarning
gmss2stage s1_logit s2_ex6, zhat(mu_logit) `header'

// Example 7
gmss dist oprobit    , name(ordered) link(mdr_prob3 k1 k2)
gmss init s2_ex7     , dist(oprobit) opt(`opt_opts') nowarning
gmss2stage s1_probit s2_ex7, zhat(mu_probit) `header'


{pstd}

{marker refs}{...}
{title:References}

{phang}
Hardin, J.W. 2002.
The Robust Variance Estimator for Two-Stage Models.
Stata Journal. 2(3), 253-266.

{phang}
Hole, A.R. 2002.
Calculating Murphy-Topel Variance Estimates in Stata: A Simplified Procedure.
Stata Journal. 6(4), 521-529.

